@extends('layouts.app')

@section('page-header')
	<!-- PAGE HEADER -->
	<div class="page-header mt-5-7 justify-content-center">
		<div class="page-leftheader text-center">
			<h4 class="page-title mb-0"><img src="{{theme_url('img/csp/cloudflare-sm.png')}}" class="fw-2 mr-2" alt=""> {{ __('Cloudflare R2 Settings') }}</h4>
			<ol class="breadcrumb mb-2 justify-content-center">
				<li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}"><i class="fa-solid fa-microchip-ai mr-2 fs-12"></i>{{ __('Admin') }}</a></li>
				<li class="breadcrumb-item" aria-current="page"><a href="{{ route('admin.davinci.configs')}}"> {{ __('AI Settings') }}</a></li>
				<li class="breadcrumb-item active" aria-current="page"><a href="#"> {{ __('API') }}</a></li>
			</ol>
		</div>
	</div>
	<!-- END PAGE HEADER -->
@endsection

@section('content')						
	<div class="row justify-content-center">
		<div class="col-lg-7 col-md-12 col-sm-12">
			<div class="card border-0">
				<div class="card-body pt-7 pl-7 pr-7 pb-6">									
					<form action="{{ route('admin.davinci.configs.api.cloudflare.store') }}" method="post" enctype="multipart/form-data">
						@csrf
						
						<div class="card shadow-0 mb-6 pt-3">							
							<div class="card-body">
								<div class="row">
									<div class="col-lg-6 col-md-6 col-sm-12">								
										<!-- ACCESS KEY -->
										<div class="input-box">								
											<h6>{{ __('Cloudflare R2 Access Key') }} <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
											<div class="form-group">							    
												<input type="text" class="form-control @error('set-r2-access-key') is-danger @enderror" id="r2-access-key" name="set-r2-access-key" value="{{ config('services.r2.key') }}" autocomplete="off">
												@error('set-r2-access-key')
													<p class="text-danger">{{ $errors->first('set-r2-access-key') }}</p>
												@enderror
											</div> 
										</div> <!-- END ACCESS KEY -->
									</div>

									<div class="col-lg-6 col-md-6 col-sm-12">
										<!-- SECRET ACCESS KEY -->
										<div class="input-box">								
											<h6>{{ __('Cloudflare R2 Secret Access Key') }} <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6> 
											<div class="form-group">							    
												<input type="text" class="form-control @error('set-r2-secret-access-key') is-danger @enderror" id="r2-secret-access-key" name="set-r2-secret-access-key" value="{{ config('services.r2.secret') }}" autocomplete="off">
												@error('set-r2-secret-access-key')
													<p class="text-danger">{{ $errors->first('set-r2-secret-access-key') }}</p>
												@enderror
											</div> 
										</div> <!-- END SECRET ACCESS KEY -->
									</div>

									<div class="col-lg-6 col-md-6 col-sm-12">								
										<div class="input-box">								
											<h6>{{ __('Cloudflare R2 Bucket Name') }} <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
											<div class="form-group">							    
												<input type="text" class="form-control @error('set-r2-bucket') is-danger @enderror" id="r2-bucket" name="set-r2-bucket" value="{{ config('services.r2.bucket') }}" autocomplete="off">
												@error('set-r2-bucket')
													<p class="text-danger">{{ $errors->first('set-r2-bucket') }}</p>
												@enderror
											</div> 
										</div> 
									</div>		
									
									<div class="col-lg-6 col-md-6 col-sm-12">								
										<div class="input-box">								
											<h6>{{ __('Cloudflare R2 Endpoint') }} <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
											<div class="form-group">							    
												<input type="text" class="form-control @error('set-r2-endpoint') is-danger @enderror" id="r2-endpoint" name="set-r2-endpoint" value="{{ config('services.r2.endpoint') }}" autocomplete="off">
												@error('set-r2-endpoint')
													<p class="text-danger">{{ $errors->first('set-r2-endpoint') }}</p>
												@enderror
											</div> 
										</div> 
									</div>

									<div class="col-lg-6 col-md-6 col-sm-12">								
										<div class="input-box">								
											<h6>{{ __('Cloudflare R2 Public URL') }} <span class="text-required"><i class="fa-solid fa-asterisk"></i></span></h6>
											<div class="form-group">							    
												<input type="text" class="form-control @error('set-r2-url') is-danger @enderror" id="r2-url" name="set-r2-url" value="{{ config('services.r2.url') }}" autocomplete="off">
												@error('set-r2-url')
													<p class="text-danger">{{ $errors->first('set-r2-url') }}</p>
												@enderror
											</div> 
										</div> 
									</div>
		
								</div>
	
							</div>
						</div>


						<!-- ACTION BUTTON -->
						<div class="border-0 text-center mb-2 mt-1">
							<button type="submit" class="btn ripple btn-primary pl-8 pr-8 pt-2 pb-2">{{ __('Save') }}</button>							
						</div>				

					</form>					
				</div>
			</div>
		</div>
	</div>
@endsection


